USE OLAP

--using RANK
SELECT product,product_cost
       ,RANK() OVER (order by product_cost) as rank --Ranking based on price
FROM products
ORDER BY product_cost --order based on price

--using DENSE_RANK
SELECT product,product_cost
       ,RANK() OVER (order by product_cost) as rank --Ranking based on price
	   ,DENSE_RANK() OVER (order by product_cost) as dense_rank --Dense Ranking based on price
FROM products
ORDER BY product_cost --order based on price

--If two products have the same price, order them alphabetically.
SELECT product,product_cost
       ,RANK() OVER (order by product_cost,product) as rank --Ranking based on price
	   ,DENSE_RANK() OVER (order by product_cost,product) as dense_rank --Dense Ranking based on price
FROM products
ORDER BY product_cost,product
